<?php

function fraud_check_manual_page() {
    $api_key = get_option('fraud_check_api_key');
    $username = get_option('fraud_check_username');
    $password = get_option('fraud_check_password');
    ?>
    <div class="wrap">
        <h1>Manual Fraud Check</h1>
        <?php if (!$api_key || !$username || !$password): ?>
            <div class="fraud-alert fraud-alert-error">
                API credentials are missing. Set them in the <a href="admin.php?page=fraud-check-settings">Settings</a>.
            </div>
        <?php else: ?>
            <div class="fraud-check-container">
                <div class="fraud-input-wrapper">
                    <input type="text" id="manual-phone" placeholder="Enter Bangladeshi phone number (e.g., 017XXXXXXXX)" class="fraud-input-field" />
                    <button class="button button-primary fraud-check-button" id="manual-check-btn">Check Fraud Status</button>
                </div>
            </div>
            <div id="manual-result" class="fraud-result-container"></div>

            <style>
                .fraud-alert {
                    padding: 12px 15px;
                    border-radius: 4px;
                    margin: 15px 0;
                    font-weight: 500;
                }
                
                .fraud-alert-error {
                    background-color: #fdecea;
                    color: #d63638;
                    border-left: 4px solid #d63638;
                }
                
                .fraud-check-container {
                    display: flex;
                    justify-content: center;
                    margin: 30px 0;
                }
                
                .fraud-input-wrapper {
                    text-align: center;
                    max-width: 400px;
                    width: 100%;
                }
                
                .fraud-input-field {
                    width: 100%;
                    padding: 12px 15px;
                    font-size: 16px;
                    border: 1px solid #8c8f94;
                    border-radius: 4px;
                    box-sizing: border-box;
                    text-align: center;
                    margin-bottom: 15px;
                    transition: border-color 0.3s ease;
                }
                
                .fraud-input-field:focus {
                    border-color: #2271b1;
                    outline: none;
                    box-shadow: 0 0 0 1px #2271b1;
                }
                
                .fraud-check-button {
                    padding: 10px 24px;
                    font-size: 16px;
                    font-weight: 500;
                    border-radius: 4px;
                    background-color: #2271b1;
                    border: none;
                    color: white;
                    cursor: pointer;
                    transition: all 0.3s ease;
                    width: 100%;
                }
                
                .fraud-check-button:hover {
                    background-color: #135e96;
                    transform: translateY(-1px);
                }
                
                .fraud-check-button:active {
                    transform: translateY(0);
                }
                
                .fraud-result-container {
                    background: #f6f7f7;
                    padding: 25px;
                    border: 1px solid #dcdcde;
                    border-radius: 8px;
                    margin: 30px auto;
                    max-width: 800px;
                    transition: all 0.3s ease;
                    box-shadow: 0 2px 5px rgba(0,0,0,0.05);
                }
                
                .fraud-result-container h4 {
                    margin-top: 0;
                    color: #1d2327;
                    border-bottom: 1px solid #dcdcde;
                    padding-bottom: 10px;
                    font-size: 18px;
                }
                
                .fraud-result-container img {
                    vertical-align: middle;
                    margin-right: 10px;
                    border-radius: 4px;
                    max-width: 50px;
                    height: auto;
                }
                
                .success-text {
                    color: #00a32a;
                }
                
                .warning-text {
                    color: #dba617;
                }
                
                .error-text {
                    color: #d63638;
                }
                
                /* Grid Layout for Courier Summaries */
                .courier-grid {
                    display: grid;
                    grid-template-columns: repeat(2, 1fr);
                    gap: 20px;
                    margin-top: 20px;
                }
                
                .courier-item {
                    background: white;
                    padding: 15px;
                    border-radius: 6px;
                    border: 1px solid #dcdcde;
                    box-shadow: 0 1px 3px rgba(0,0,0,0.05);
                    display: flex;
                }
                
                .courier-item-content {
                    display: flex;
                    align-items: center;
                    margin-bottom: 10px;
                    width: 100%;
                }
                
                .courier-item-details {
                    margin-left: 10px;
                    flex-grow: 1;
                }
                
                .courier-item-stats {
                    font-size: 14px;
                    line-height: 1.5;
                    display: flex;
                    flex-direction: column;
                    margin-left: 15px;
                    text-align: right;
                    min-width: 120px;
                }
                
                /* Responsive adjustments */
                @media (max-width: 782px) {
                    .courier-grid {
                        grid-template-columns: 1fr;
                    }
                    
                    .fraud-input-wrapper {
                        padding: 0 15px;
                    }
                    
                    .fraud-result-container {
                        margin: 20px 15px;
                        padding: 15px;
                    }
                    
                    .courier-item {
                        flex-direction: column;
                    }
                    
                    .courier-item-stats {
                        margin-left: 0;
                        margin-top: 10px;
                        text-align: left;
                        flex-direction: row;
                        justify-content: space-between;
                    }
                }
            </style>

            <script>
                jQuery(document).ready(function($) {
                    $('#manual-check-btn').click(function () {
                        let phone = $('#manual-phone').val().replace(/^\+?88/, '');
                        if (!/^01[3-9][0-9]{8}$/.test(phone)) {
                            $('#manual-result').html('<div class="fraud-alert warning-text">Please enter a valid Bangladeshi mobile number (e.g., 017XXXXXXXX).</div>');
                            return;
                        }

                        $('#manual-result').html('<div class="fraud-alert">Checking phone number... <span class="spinner is-active" style="float:none;margin-left:5px;"></span></div>');

                        $.ajax({
                            url: 'https://fraudbd.com/api/check-courier-info',
                            method: 'POST',
                            headers: {
                                'api_key': '<?php echo esc_js($api_key); ?>',
                                'user_name': '<?php echo esc_js($username); ?>',
                                'password': '<?php echo esc_js($password); ?>',
                                'Content-Type': 'application/json'
                            },
                            data: JSON.stringify({ phone_number: phone }),
                            success: function (res) {
                                if (res.status && res.data) {
                                    let html = '<div class="fraud-result-content">';
                                    html += '<h4>Fraud Check Summary</h4>';
                                    html += `<p><strong>Total Orders:</strong> ${res.data.totalSummary.total}</p>`;
                                    html += `<p><strong class="success-text">Successful Deliveries:</strong> ${res.data.totalSummary.success}</p>`;
                                    html += `<p><strong class="error-text">Cancelled Orders:</strong> ${res.data.totalSummary.cancel}</p>`;
                                    html += `<p><strong>Success Rate:</strong> <span class="success-text">${res.data.totalSummary.successRate}%</span></p>`;
                                    html += `<p><strong>Cancel Rate:</strong> <span class="error-text">${res.data.totalSummary.cancelRate}%</span></p>`;
                                    html += '<h4>Courier Performance</h4>';
                                    html += '<div class="courier-grid">';
                                    
                                    for (const [courier, info] of Object.entries(res.data.Summaries)) {
                                        html += `<div class="courier-item">`;
                                        html += `<div class="courier-item-content">`;
                                        html += `<img src="${info.logo}" alt="${courier}" />`;
                                        html += `<div class="courier-item-details"><strong>${courier}</strong></div>`;
                                        html += `<div class="courier-item-stats">`;
                                        html += `<span>Total: ${info.total}</span>`;
                                        html += `<span class="success-text">Success: ${info.success}</span>`;
                                        html += `<span class="error-text">Cancel: ${info.cancel}</span>`;
                                        html += `</div>`;
                                        html += `</div>`;
                                        html += `</div>`;
                                    }
                                    
                                    html += '</div></div>';
                                    $('#manual-result').html(html);
                                } else {
                                    $('#manual-result').html('<div class="fraud-alert error-text">' + (res.message || 'No data found for this phone number.') + '</div>');
                                }
                            },
                            error: function (xhr, status, error) {
                                let message = 'API request failed. Please try again.';
                                if (xhr.responseJSON && xhr.responseJSON.message) {
                                    message = xhr.responseJSON.message;
                                }
                                $('#manual-result').html('<div class="fraud-alert error-text">' + message + '</div>');
                            }
                        });
                    });
                    
                    // Allow checking by pressing Enter key
                    $('#manual-phone').keypress(function(e) {
                        if (e.which === 13) {
                            $('#manual-check-btn').click();
                        }
                    });
                });
            </script>
        <?php endif; ?>
    </div>
    <?php
}